﻿var myReports = {
    context: $(".v-myReports"),
    datatable: null,
    bindEvents: function () {
        this.context.on("click", ".h-newReport li", function () {
            myReports.createReport($(this).attr("data-type"));
        });
    },
    initializeDataTable: function () {
        var toolBarItems = [];
        var userRightsVal = $("#UserRights", myReports.context).val();

        if (userRightsVal && userRightsVal.length > 0) {
            var userRights = userRightsVal.split(",");

            if (userRights && userRights.length > 0) {
                _.each(userRights, function (item) {
                    toolBarItems.push({ "Action": item, "Label": resources["New" + item + "Report"], "DisplayMode": dataTables.itemDisplayMode.always });
                });
            }
        }

        this.datatable = $(".h-myReportsTable", myReports.context).a4datatable({
            ajaxAction: a4.getAction("GetReports", "Home", "Portal"),
            columns: [
                { "Name": "ReportName", "Data": "ReportName", "Title": resources.ReportName, "Width": "25%" },
                { "Name": "ReportType", "Data": "ReportTypeEnum", "Title": resources.ReportType },
                { "Name": "Description", "Data": "Description", "Title": resources.Description, "Width": "35%" },
                { "Name": "ModifiedDate", "Data": "ModifiedOn", "Title": resources.ModifiedOn },
                { "Name": "IsPrivate", "Data": "IsPrivate", "Title": resources.Status, "Label": "IsPrivateLabel", "Type": "boolean" }
            ],
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                myReports.createReport(data.action);
            },
            contextMenuItems: [
                { "Action": "view", "Label": resources.View },
                { "Action": "edit", "Label": resources.Edit, "DisplayCondition": function (data) { return data.IsPrivate;} },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.IsPrivate; } },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "view":
                        myReports.viewReport(row);
                        break;
                    case "edit":
                        myReports.editReport(row.ExternalId);
                        break;
                    case "delete":
                        myReports.deleteReport(row.ExternalId);
                        break;
                }
            },
        });
    },
    viewReport: function (row) {
        var url;

        if (row.ReportType == "SurveyStatus") {
            url = a4.getSurveyAction("PortalParticipation", "Analyze", { surveyId: row.ExternalId });
        }
        else if (row.ReportType == "QuickResults") {
            url = a4.getSurveyAction("PortalResults", "Analyze", { surveyId: row.ExternalId });
        }
        else if (row.ReportType == "OfflineActivity") {
            url = a4.getSurveyAction("PortalOfflineActivity", "Analyze", { surveyId: row.ExternalId });
        }
        else {
            var reportingUrl = $("#ReportingBaseUrl").val();

            if (row.ReportType == "Productivity") {
                reportingUrl += "Portal/DisplayReport.aspx";
            }
            else if (row.ReportType == "Questionnaire") {
                reportingUrl += "Questionnaire/QPrintDisplay.aspx";
            }
            else {
                reportingUrl += "Portal/DisplayGenericReport.aspx";
            }

            url = reportingUrl + '?showloading=true&reportId=' + row.ExternalId;
        }

        window.open(url, '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    deleteReport: function (id) {
        modalDialog.showConfirmDialog(confirmDeleteReportResources, function () {
            a4.callServerMethod(a4.getAction("DeleteReport", "Home", "Portal"), { id: id },
                function (result) {
                    myReports.datatable.a4datatable("refresh");
                });
        }, 250, 500, true, {});
    },
    createReport: function (type) {
        window.open($("#ReportingBaseUrl").val() + 'Default.aspx?CreateReport=' + type.toLowerCase(), '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    editReport: function (id) {
        window.open($("#ReportingBaseUrl").val() + 'Default.aspx?EditReport=' + id, '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    refreshContent: function (portalId) {
        window.location = a4.getAction("Index", "Home", "Portal", { id: portalId });
    },
    updateUserName: function (userName) {
        $(".v-userName", myReports.context).text(userName);
    },
    setStickyFooter: function () {
        var footerHeight = $("#footer").outerHeight(true);
        $("#main").css("margin-bottom", -footerHeight);
        $(".content", myReports.context).css("padding-bottom", footerHeight);
    }
}

$(document).ready(function () {
    if (myReports.context.length > 0) {
        myReports.setStickyFooter();
        myReports.initializeDataTable();
        myReports.bindEvents();
    }
});
